using Verse;
using RimWorld;
using System.Reflection;

namespace JTReplaceWalls
{
	public class Designator_Build_JT : Designator_Build
    {
        FieldInfo stuffField = null;
        ThingDef stuff = null;

        public static bool wall = false;
        public static bool embrasure = false;

        public Designator_Build_JT(BuildableDef entDef) : base(entDef)
		{
        }

		public override AcceptanceReport CanDesignateCell(IntVec3 c)
        {
            if (stuffField == null) //Caches reflection result since this method is called a lot
            {
                stuffField = typeof(Designator_Build).GetField("stuffDef", BindingFlags.NonPublic | BindingFlags.Instance);
            } else
            {
                //Gets private ThingDef stuffDef from Designator_Build
                stuff = (ThingDef)stuffField.GetValue(this);
            }

            if (!wall && DefDatabase<ThingDef>.GetNamed("Wall", false) != null)
            {
                DefDatabase<ThingDef>.GetNamed("Wall").building.canPlaceOverWall = true;
                wall = true;

            }
            if (!embrasure && DefDatabase<ThingDef>.GetNamed("Embrasure", false) != null)
            {
                DefDatabase<ThingDef>.GetNamed("Embrasure").building.canPlaceOverWall = true;
                embrasure = true;
                Log.Message("JTReplaceWalls: detected Embrasure");
            }

            return GenConstruct_JT.CanPlaceBlueprintAt(entDef, c, placingRot, stuff, DebugSettings.godMode, null);
		}
        

	}
}
